package gov.va.genisis2.converter;

import static org.junit.Assert.assertEquals;

import java.util.ArrayList;
import java.util.List;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.common.enums.WorkflowStatusEnum;
import gov.va.genisis2.dto.RequestDTO;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.util.DateUtil;
import gov.va.genisis2.util.Helper;

/**
 * @author Getaneh Kassahun
 * 
 */

public class RequestConverterTest extends AbstractMockMvcTests {

	private RequestConverter requestConverter;
	private RequestTypeConverter requestTypeConverter;
	private StudyApprovalConverter studyApprovalConverter;
	private SourceConverter sourceConverter;
	private DataTypeConverter dataTypeConverter;

	@Before
	public void setUp() {

		requestConverter = new RequestConverter();
		requestTypeConverter = new RequestTypeConverter();
		studyApprovalConverter = new StudyApprovalConverter();
		sourceConverter = new SourceConverter();
		dataTypeConverter = new DataTypeConverter();

//TODO		requestConverter.setDataTypeConverter(dataTypeConverter);
//TODO		requestConverter.setRequestTypeConverter(requestTypeConverter);
//TODO		requestConverter.setStudyApprovalConverter(studyApprovalConverter);
//TODO		requestConverter.setSourceConverter(sourceConverter);
//TODO		requestConverter.getDataTypeConverter();

	}

	@Test
	@Ignore
	public void convert() {
		Request request = Helper.getExistingRequest();
		request.setSourceId(1);

		assertEquals("Postman Sample Create Request", requestConverter.convert(request).getTitle());
		Assert.assertNotEquals("Sample Create Request", requestConverter.convert(request).getTitle());
	}

	@Test
	@Ignore
	public void convert2() {
		Request request = Helper.getExistingRequest();
		RequestDTO requestDto = new RequestDTO();
		requestDto.setId(request.getId());
		requestDto.setProcessId(0);
		requestDto.setTitle(request.getTitle());
		requestDto.setDescription(request.getDescription());
		requestDto.setStatusDescription("Return");
		requestDto.setCreatedOn(DateUtil.getTodaysDate());
		requestDto.setModifiedOn(request.getModifiedOn());
		requestDto.setCreatedBy(request.getCreatedBy());
		requestDto.setModifiedBy(request.getModifiedBy());
		requestDto.setApproverId(request.getApproverId());
		requestDto.setTaskId(request.getTaskId());
		requestDto.setDataTypeId(request.getDataTypeId());
		requestDto.setSourceId(1);
		requestDto.setDataType(Helper.getDataTypeDTO());
		requestDto.setRequestType(Helper.getRequestTypeDTO());
		requestDto.setRequestTypeId(Helper.getRequestTypeDTO().getId());
		requestDto.setSource(Helper.getSourceDTO());
		requestDto.setStudyApprovalId(Helper.getStudyApproval().getId());
		requestDto.setStudyApproval(Helper.getStudyApprovalDTO());

		assertEquals("Postman Sample Create Request", requestConverter.convert(request).getTitle());
		assertEquals("Draft", requestConverter.convert(requestDto).getStatusDescription());
		Assert.assertNotEquals("Draft", requestConverter.convert(requestDto).getTitle());

	}

	@Test
	@Ignore
	public void convertRequests() {
		List<Request> requests = new ArrayList<>();
		requests.add(Helper.getExistingRequest());
		Assert.assertFalse(requestConverter.convertRequests(requests).isEmpty());
		Assert.assertTrue(!requestConverter.convertRequests(requests).isEmpty());
	}

	@Test
	public void populateRequest() {
		Request request = Helper.getNewRequest();
		request.setProcessId(0);
		assertEquals("Submitted", requestConverter.populateRequest(1, Helper.getRequestDTO(), WorkflowStatusEnum.SUBMITTED.getDesc(), Helper.getExistingRequest(), request).getStatusDescription());
		assertEquals("Submitted", requestConverter.populateRequest(1, Helper.getRequestDTO(), WorkflowStatusEnum.RETURNTODDM.getDesc(), Helper.getExistingRequest(), request).getStatusDescription());
		Assert.assertNotEquals("Draft", requestConverter.populateRequest(1, Helper.getRequestDTO(), WorkflowStatusEnum.SUBMITTED.getDesc(), Helper.getExistingRequest(), Helper.getNewRequest()).getStatusDescription());
		request.setStatusDescription("");
		request.setDescription("");
		request.setTitle("");
		assertEquals("Return", requestConverter.populateRequest(1, Helper.getRequestDTO(), WorkflowStatusEnum.UPDATE.getDesc(), Helper.getExistingRequest(), request).getStatusDescription());
		assertEquals("Postman Sample Create Request", requestConverter.populateRequest(1, Helper.getRequestDTO(), WorkflowStatusEnum.SUBMITTED.getDesc(), Helper.getExistingRequest(), request).getTitle());
	}

}
